/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.websm.bridge.WSession;
import com.ibm.websm.bridge.WSessionMgr;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EAccessSupport;
import com.ibm.websm.etc.EAuthorization;
import com.ibm.websm.mobject.MOClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class HscEAccess
extends EAccessSupport {
    public static final String HSC_ADMIN_ROLE = "HSC_Admin";
    public static final String HSC_OP_ROLE = "HSC_Operator";
    public static final String HSC_ADV_OP_ROLE = "HSC_Adv_Operator";
    public static final String HSC_SYS_PROG_ROLE = "HSC_Sys_Prog";
    public static final String HSC_SERV_REP_ROLE = "HSC_Serv_Rep";
    public static final String HSC_PE_MODE_ROLE = "HSC_PEMODE";
    public static final String HSC_VIEWER_ROLE = "HSC_Viewer";
    public static final String HSC_LOG_DISPLAYER = "HSCLogDisplayer";
    public static final String HSC_EVENT_TRACE = "HSCEventTrace";
    public static final String DISPLAY_SYSTEM_EVENTS = "DisplaySystemEvents";
    public static final String OPEN_XTERM_SHELL = "OpenXTermShell";
    public static final String OS_HARDWARE_ERROR_DETECTION = "OSHardwareErrorDetection";
    public static final String BACKUP_HSC_DATA = "BackupHscData";
    public static final String SAVE_UPGRADE_DATA = "SaveUpgradeData";
    public static final String INSTALL_SERVICE = "InstallService";
    public static final String FORMAT_MEDIA = "FormatMedia";
    public static final String RECEIVE_CORRECTIVE_SERVICE = "ReceiveCorrectiveService";
    public static final String VIEW_HSC_DATE_TIME = "ViewHSCDateTime";
    public static final String UPDATE_HSC_DATE_TIME = "UpdateHSCDateTime";
    public static final String VIEW_CONSOLE_INFORMATION = "ViewConsoleInformation";
    public static final String HSC_NETWORK_SETTINGS = "HSCNetworkSettings";
    public static final String HSC_NETWORK_TESTING = "HSCNetworkTesting";
    public static final String SCHEDULE_OPERATIONS = "ScheduleOperations";
    public static final String HSC_REMOTE_CMD = "RemoteCmdExecution";
    public static final String HSC_REMOTE_VTERM = "RemoteVterm";
    public static final String CHANGE_LOCALE = "ChangeLocale";
    public static final String SERVICE_FOCAL_POINT_VIEW = "ServiceFocalPointView";
    public static final String SERVICE_FOCAL_POINT_UPDATE = "ServiceFocalPointUpdate";
    public static final String SERVICE_FOCAL_POINT_SE_UPDATE = "ServiceFocalPointSEUpdate";
    public static final String SERVICE_FOCAL_POINT_ERROR_DATA = "ServiceFocalPointErrorData";
    public static final String SERVICE_FOCAL_POINT_SERVICE_EVENT = "ServiceFocalPointServiceEvent";
    public static final String SERVICE_FOCAL_POINT_CALL_HOME = "ServiceFocalPointCallHome";
    public static final String HARDWARE_SERVICE_FUNCTIONS_LED = "HardwareServiceFunctionsLED";
    public static final String ISC_CREATE_PROFILE = "CreateInvScoutProfile";
    public static final String ISC_UCODE_SURVEY = "DoMicrocodeSurvey";
    public static final String ISC_COLLECT_VPD = "DoVPDCollection";
    public static final String ISC_RESTART = "RestartInvScoutDaemon";
    public static final String VIEW_USER = "ViewUser";
    public static final String MODIFY_USER = "ModifyUser";
    public static final String DELETE_USER = "DeleteUser";
    public static final String CREATE_USER = "CreateUser";
    public static final String CHANGE_USER_PASSWORD = "ChangeUserPassword";
    public static final String SECURITY_ADMIN = "SecurityAdmin";
    public static final String SVAGENT_USER = "SVAgentUser";
    public static final String FRAME_RESET = "FrameReset";
    public static final String FRAME_REFRESH = "FrameRefresh";
    public static final String FRAME_INITIALIZE = "FrameInitialize";
    public static final String FRAME_MODIFY = "FrameModify";
    public static final String FRAME_VIEW = "FrameView";
    public static final String FRAME_DEACTIVATE_IO = "FrameDeactivateIO";
    public static final String FRAME_DEACTIVATE_CSP = "FrameDeactivateCSP";
    public static final String FRAME_DEACTIVATE_FSN = "FrameDeactivateFSN";
    public static final String CEC_POWER_ON = "CECPowerOn";
    public static final String CEC_FORCED_LOCK_RELEASE = "CECForcedLockRelease";
    public static final String CEC_POWER_OFF = "CECPowerOff";
    public static final String CEC_DELETE = "CECDelete";
    public static final String CEC_VIEW = "CECView";
    public static final String CEC_MODIFY = "CECModify";
    public static final String CEC_OPEN_TERMINAL = "CECOpenTerminal";
    public static final String RESTORE_PROFILE_DATA = "RestoreProfileData";
    public static final String BACKUP_PROFILE_DATA = "BackupProfileData";
    public static final String REMOVE_PROFILE_DATA = "RemoveProfileData";
    public static final String CEC_CLOSE_TERMINAL = "CECCloseTerminal";
    public static final String CEC_INITIALIZE = "CECInitialize";
    public static final String LPAR_CREATE = "LPARCreate";
    public static final String LPAR_MODIFY = "LPARModify";
    public static final String LPAR_VIEW = "LPARView";
    public static final String LPAR_ACTIVATE = "LPARActivate";
    public static final String LPAR_DELETE = "LPARDelete";
    public static final String LPAR_VIRTUAL_RESET = "LPARVirtualReset";
    public static final String LPAR_READ_ERROR_VALUE = "LPARReadErrorValue";
    public static final String PPAR_SETUP = "PPARSetup";
    public static final String PPAR_REMOVE = "PPARRemove";
    public static final String PPAR_UPDATE = "PPARUpdate";
    public static final String CUOD_LICENSE = "License";
    public static final String CUOD_PROCESSOR = "Processor";
    public static final String CUOD_MEMORY = "Memory";
    public static final String PART_PROFILE_CREATE = "PartProfileCreate";
    public static final String PART_PROFILE_MODIFY = "PartProfileModify";
    public static final String PART_PROFILE_COPY = "PartProfileCopy";
    public static final String PART_PROFILE_DELETE = "PartProfileDelete";
    public static final String PART_PROFILE_VIEW = "PartProfileView";
    public static final String PART_PROFILE_ACTIVATE = "PartProfileActivate";
    public static final String PART_PROFILE_CHANGE_DEFAULT = "PartProfileChangeDefault";
    public static final String DLPAR_TASK = "DLPARTask";
    public static final String SYS_PROFILE_CREATE = "SysProfileCreate";
    public static final String SYS_PROFILE_VIEW = "SysProfileView";
    public static final String SYS_PROFILE_MODIFY = "SysProfileModify";
    public static final String SYS_PROFILE_DELETE = "SysProfileDelete";
    public static final String SYS_PROFILE_COPY = "SysProfileCopy";
    public static final String SYS_PROFILE_ACTIVATE = "SysProfileActivate";
    public static final String SYS_PROFILE_VALIDATE = "SysProfileValidate";
    public static final String REBUILD_HSC = "RebuildHSC";
    public static final String RECOVER_PARTITION_DATA = "RecoverPartitionData";
    public static final String HMC_SHUTDOWN = "HmcShutdown";
    private String _taskName;
    private static Hashtable _taskRoleMap;
    private static Hashtable _readAccess;
    private static Hashtable _writeAccess;

    public HscEAccess(String string) {
        super(false, null, (Vector)null);
        this._taskName = string;
    }

    public boolean hasReadAccess(EAuthorization eAuthorization) {
        return this.checkAccess(eAuthorization.getGroups(), "READ_ACCESS");
    }

    public boolean hasWriteAccess(EAuthorization eAuthorization) {
        return this.checkAccess(eAuthorization.getGroups(), "WRITE_ACCESS");
    }

    public boolean hasAccess(EAuthorization eAuthorization) {
        return this.checkAccess(eAuthorization.getGroups(), "HAS_ACCESS");
    }

    private boolean checkAccess(Vector vector, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "getRoles -> " + vector.toString();
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                Vector vector2 = null;
                string2 = "Role : [" + string5 + "] -> ";
                try {
                    if (string.trim().equals("HAS_ACCESS")) {
                        vector2 = (Vector)_taskRoleMap.get(string5);
                    }
                    if (string.trim().equals("READ_ACCESS")) {
                        vector2 = (Vector)_readAccess.get(string5);
                    }
                    if (string.trim().equals("WRITE_ACCESS")) {
                        vector2 = (Vector)_writeAccess.get(string5);
                    }
                    if (vector2 == null || !vector2.contains(this._taskName)) continue;
                    return true;
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                }
            }
        }
        if (IDebug.enabled) {
            IDebug.println((String)(string4 + "\n" + string2 + this._taskName + " is disabled"));
        }
        return false;
    }

    public static boolean checkAccess(String string, String string2, String string3) {
        Vector vector = null;
        if (string2.trim().equals("HAS_ACCESS")) {
            vector = (Vector)_taskRoleMap.get(string);
        }
        if (string2.trim().equals("READ_ACCESS")) {
            vector = (Vector)_readAccess.get(string);
        }
        if (string2.trim().equals("WRITE_ACCESS")) {
            vector = (Vector)_writeAccess.get(string);
        }
        return vector != null && vector.contains(string3);
    }

    private void writeLog(String string) {
        try {
            File file = new File("/tmp/hsctasks.out");
            if (!file.exists()) {
                file.createNewFile();
            }
            file.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("/tmp/hsctasks.out", true)));
            if (printWriter != null) {
                printWriter.println("\n# " + string + " is disabled");
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static EAuthorization getAuthorization(MOClass mOClass) {
        try {
            WSession wSession = WSessionMgr.getSessionMgr().getSession(mOClass.getHost().getName());
            return wSession.getRemoteSystem().getAuthorization();
        }
        catch (Exception exception) {
            new ErrorPanel(exception.getMessage(), "Unable to get the Authorization").show();
            return null;
        }
    }

    public static boolean hasAdminRole(EAuthorization eAuthorization) {
        Vector vector = eAuthorization.getGroups();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.equals(HSC_ADMIN_ROLE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSysAdminRole(EAuthorization eAuthorization) {
        Vector vector = eAuthorization.getGroups();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.equals(HSC_SYS_PROG_ROLE)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        vector.addElement(UPDATE_HSC_DATE_TIME);
        vector.addElement(MODIFY_USER);
        vector.addElement(DELETE_USER);
        vector.addElement(CREATE_USER);
        vector.addElement(FRAME_VIEW);
        vector.addElement(FRAME_REFRESH);
        vector.addElement(FRAME_MODIFY);
        vector.addElement(CHANGE_USER_PASSWORD);
        vector.addElement(REBUILD_HSC);
        vector.addElement(CEC_MODIFY);
        vector.addElement(SYS_PROFILE_MODIFY);
        vector.addElement(LPAR_MODIFY);
        vector.addElement(PART_PROFILE_MODIFY);
        vector.addElement(RECOVER_PARTITION_DATA);
        vector7.addElement(VIEW_HSC_DATE_TIME);
        vector7.addElement(CEC_VIEW);
        vector7.addElement(FRAME_VIEW);
        vector7.addElement(LPAR_VIEW);
        vector7.addElement(SYS_PROFILE_VIEW);
        vector7.addElement(CHANGE_USER_PASSWORD);
        vector7.addElement(SERVICE_FOCAL_POINT_VIEW);
        vector7.addElement(PART_PROFILE_VIEW);
        vector7.addElement(VIEW_USER);
        vector7.addElement(UPDATE_HSC_DATE_TIME);
        vector7.addElement(VIEW_CONSOLE_INFORMATION);
        vector7.addElement(MODIFY_USER);
        vector7.addElement(CEC_MODIFY);
        vector7.addElement(FRAME_MODIFY);
        vector7.addElement(SYS_PROFILE_MODIFY);
        vector7.addElement(LPAR_MODIFY);
        vector7.addElement(PART_PROFILE_MODIFY);
        vector7.addElement(DISPLAY_SYSTEM_EVENTS);
        vector7.addElement(FRAME_REFRESH);
        vector2.addElement(BACKUP_HSC_DATA);
        vector2.addElement(FORMAT_MEDIA);
        vector2.addElement(UPDATE_HSC_DATE_TIME);
        vector2.addElement(CEC_OPEN_TERMINAL);
        vector2.addElement(CEC_CLOSE_TERMINAL);
        vector2.addElement(CEC_POWER_ON);
        vector2.addElement(CEC_MODIFY);
        vector2.addElement(SYS_PROFILE_MODIFY);
        vector2.addElement(SYS_PROFILE_ACTIVATE);
        vector2.addElement(LPAR_MODIFY);
        vector2.addElement(LPAR_ACTIVATE);
        vector2.addElement(PART_PROFILE_MODIFY);
        vector2.addElement(PART_PROFILE_ACTIVATE);
        vector2.addElement(REBUILD_HSC);
        vector2.addElement(SERVICE_FOCAL_POINT_VIEW);
        vector2.addElement(ISC_RESTART);
        vector2.addElement(SVAGENT_USER);
        vector2.addElement(CHANGE_LOCALE);
        vector2.addElement(RECEIVE_CORRECTIVE_SERVICE);
        vector2.addElement(SYS_PROFILE_VALIDATE);
        vector2.addElement(CUOD_LICENSE);
        vector2.addElement(FRAME_REFRESH);
        vector2.addElement(FRAME_VIEW);
        vector2.addElement(FRAME_MODIFY);
        vector3.addElement(BACKUP_HSC_DATA);
        vector3.addElement(SAVE_UPGRADE_DATA);
        vector3.addElement(FORMAT_MEDIA);
        vector3.addElement(VIEW_HSC_DATE_TIME);
        vector3.addElement(UPDATE_HSC_DATE_TIME);
        vector3.addElement(SCHEDULE_OPERATIONS);
        vector3.addElement(HSC_NETWORK_SETTINGS);
        vector3.addElement(HSC_NETWORK_TESTING);
        vector3.addElement(HSC_REMOTE_CMD);
        vector3.addElement(DISPLAY_SYSTEM_EVENTS);
        vector3.addElement(HMC_SHUTDOWN);
        vector3.addElement(CEC_POWER_ON);
        vector3.addElement(CEC_POWER_OFF);
        vector3.addElement(CEC_OPEN_TERMINAL);
        vector3.addElement(CEC_CLOSE_TERMINAL);
        vector3.addElement(CEC_MODIFY);
        vector3.addElement(CEC_FORCED_LOCK_RELEASE);
        vector3.addElement(SERVICE_FOCAL_POINT_VIEW);
        vector3.addElement(LPAR_CREATE);
        vector3.addElement(LPAR_MODIFY);
        vector3.addElement(DLPAR_TASK);
        vector3.addElement(LPAR_ACTIVATE);
        vector3.addElement(LPAR_VIRTUAL_RESET);
        vector3.addElement(LPAR_READ_ERROR_VALUE);
        vector3.addElement(PPAR_SETUP);
        vector3.addElement(PPAR_REMOVE);
        vector3.addElement(PPAR_UPDATE);
        vector3.addElement(CUOD_LICENSE);
        vector3.addElement(CUOD_PROCESSOR);
        vector3.addElement(CUOD_MEMORY);
        vector3.addElement(FRAME_REFRESH);
        vector3.addElement(FRAME_VIEW);
        vector3.addElement(FRAME_MODIFY);
        vector3.addElement(PART_PROFILE_ACTIVATE);
        vector3.addElement(PART_PROFILE_CREATE);
        vector3.addElement(PART_PROFILE_MODIFY);
        vector3.addElement(PART_PROFILE_COPY);
        vector3.addElement(PART_PROFILE_CHANGE_DEFAULT);
        vector3.addElement(SYS_PROFILE_CREATE);
        vector3.addElement(SYS_PROFILE_MODIFY);
        vector3.addElement(SYS_PROFILE_COPY);
        vector3.addElement(SYS_PROFILE_ACTIVATE);
        vector3.addElement(RESTORE_PROFILE_DATA);
        vector3.addElement(BACKUP_PROFILE_DATA);
        vector3.addElement(REMOVE_PROFILE_DATA);
        vector3.addElement(REBUILD_HSC);
        vector3.addElement(ISC_CREATE_PROFILE);
        vector3.addElement(ISC_UCODE_SURVEY);
        vector3.addElement(ISC_COLLECT_VPD);
        vector3.addElement(ISC_RESTART);
        vector3.addElement(SVAGENT_USER);
        vector3.addElement(CHANGE_LOCALE);
        vector3.addElement(RECEIVE_CORRECTIVE_SERVICE);
        vector3.addElement(SYS_PROFILE_VALIDATE);
        vector3.addElement(HSC_REMOTE_VTERM);
        vector4.addElement(BACKUP_HSC_DATA);
        vector4.addElement(SAVE_UPGRADE_DATA);
        vector4.addElement(UPDATE_HSC_DATE_TIME);
        vector4.addElement(INSTALL_SERVICE);
        vector4.addElement(FORMAT_MEDIA);
        vector4.addElement(VIEW_HSC_DATE_TIME);
        vector4.addElement(VIEW_CONSOLE_INFORMATION);
        vector4.addElement(HSC_NETWORK_SETTINGS);
        vector4.addElement(HSC_NETWORK_TESTING);
        vector4.addElement(SCHEDULE_OPERATIONS);
        vector4.addElement(DISPLAY_SYSTEM_EVENTS);
        vector4.addElement(HSC_REMOTE_CMD);
        vector4.addElement(FRAME_INITIALIZE);
        vector4.addElement(FRAME_RESET);
        vector4.addElement(FRAME_REFRESH);
        vector4.addElement(FRAME_MODIFY);
        vector4.addElement(FRAME_VIEW);
        vector4.addElement(FRAME_DEACTIVATE_IO);
        vector4.addElement(FRAME_DEACTIVATE_CSP);
        vector4.addElement(FRAME_DEACTIVATE_FSN);
        vector4.addElement(SERVICE_FOCAL_POINT_VIEW);
        vector4.addElement(SERVICE_FOCAL_POINT_UPDATE);
        vector4.addElement(SERVICE_FOCAL_POINT_SE_UPDATE);
        vector4.addElement(HARDWARE_SERVICE_FUNCTIONS_LED);
        vector4.addElement(HSC_REMOTE_VTERM);
        vector4.addElement(CEC_OPEN_TERMINAL);
        vector4.addElement(CEC_CLOSE_TERMINAL);
        vector4.addElement(CEC_POWER_ON);
        vector4.addElement(CEC_FORCED_LOCK_RELEASE);
        vector4.addElement(CEC_POWER_OFF);
        vector4.addElement(CEC_DELETE);
        vector4.addElement(CEC_MODIFY);
        vector4.addElement(CEC_INITIALIZE);
        vector4.addElement(RECOVER_PARTITION_DATA);
        vector4.addElement(LPAR_CREATE);
        vector4.addElement(LPAR_MODIFY);
        vector4.addElement(DLPAR_TASK);
        vector4.addElement(LPAR_ACTIVATE);
        vector4.addElement(LPAR_DELETE);
        vector4.addElement(LPAR_VIRTUAL_RESET);
        vector4.addElement(LPAR_READ_ERROR_VALUE);
        vector4.addElement(PPAR_SETUP);
        vector4.addElement(PPAR_REMOVE);
        vector4.addElement(PPAR_UPDATE);
        vector4.addElement(CUOD_LICENSE);
        vector4.addElement(CUOD_PROCESSOR);
        vector4.addElement(CUOD_MEMORY);
        vector4.addElement(PART_PROFILE_CREATE);
        vector4.addElement(PART_PROFILE_MODIFY);
        vector4.addElement(PART_PROFILE_COPY);
        vector4.addElement(PART_PROFILE_DELETE);
        vector4.addElement(PART_PROFILE_ACTIVATE);
        vector4.addElement(PART_PROFILE_CHANGE_DEFAULT);
        vector4.addElement(SYS_PROFILE_CREATE);
        vector4.addElement(SYS_PROFILE_MODIFY);
        vector4.addElement(SYS_PROFILE_DELETE);
        vector4.addElement(SYS_PROFILE_COPY);
        vector4.addElement(SYS_PROFILE_ACTIVATE);
        vector4.addElement(MODIFY_USER);
        vector4.addElement(DELETE_USER);
        vector4.addElement(CREATE_USER);
        vector4.addElement(CHANGE_USER_PASSWORD);
        vector4.addElement(RESTORE_PROFILE_DATA);
        vector4.addElement(BACKUP_PROFILE_DATA);
        vector4.addElement(REMOVE_PROFILE_DATA);
        vector4.addElement(REBUILD_HSC);
        vector4.addElement(ISC_CREATE_PROFILE);
        vector4.addElement(ISC_UCODE_SURVEY);
        vector4.addElement(ISC_COLLECT_VPD);
        vector4.addElement(ISC_RESTART);
        vector4.addElement(SECURITY_ADMIN);
        vector4.addElement(SVAGENT_USER);
        vector4.addElement(CHANGE_LOCALE);
        vector4.addElement(RECEIVE_CORRECTIVE_SERVICE);
        vector4.addElement(SYS_PROFILE_VALIDATE);
        vector4.addElement(HMC_SHUTDOWN);
        vector5.addElement(DISPLAY_SYSTEM_EVENTS);
        vector5.addElement(BACKUP_HSC_DATA);
        vector5.addElement(SAVE_UPGRADE_DATA);
        vector5.addElement(VIEW_HSC_DATE_TIME);
        vector5.addElement(UPDATE_HSC_DATE_TIME);
        vector5.addElement(HSC_NETWORK_SETTINGS);
        vector5.addElement(HSC_NETWORK_TESTING);
        vector5.addElement(FORMAT_MEDIA);
        vector5.addElement(INSTALL_SERVICE);
        vector5.addElement(HSC_REMOTE_CMD);
        vector5.addElement(VIEW_CONSOLE_INFORMATION);
        vector5.addElement(SERVICE_FOCAL_POINT_VIEW);
        vector5.addElement(SERVICE_FOCAL_POINT_UPDATE);
        vector5.addElement(SERVICE_FOCAL_POINT_SE_UPDATE);
        vector5.addElement(HARDWARE_SERVICE_FUNCTIONS_LED);
        vector5.addElement(CEC_OPEN_TERMINAL);
        vector5.addElement(CEC_CLOSE_TERMINAL);
        vector5.addElement(CEC_POWER_ON);
        vector5.addElement(CEC_FORCED_LOCK_RELEASE);
        vector5.addElement(CEC_POWER_OFF);
        vector5.addElement(CEC_MODIFY);
        vector5.addElement(FRAME_RESET);
        vector5.addElement(FRAME_REFRESH);
        vector5.addElement(FRAME_INITIALIZE);
        vector5.addElement(FRAME_MODIFY);
        vector5.addElement(FRAME_VIEW);
        vector5.addElement(FRAME_DEACTIVATE_IO);
        vector5.addElement(FRAME_DEACTIVATE_CSP);
        vector5.addElement(FRAME_DEACTIVATE_FSN);
        vector5.addElement(LPAR_ACTIVATE);
        vector5.addElement(LPAR_MODIFY);
        vector5.addElement(LPAR_VIRTUAL_RESET);
        vector5.addElement(LPAR_READ_ERROR_VALUE);
        vector5.addElement(PART_PROFILE_ACTIVATE);
        vector5.addElement(PART_PROFILE_COPY);
        vector5.addElement(PART_PROFILE_MODIFY);
        vector5.addElement(SYS_PROFILE_ACTIVATE);
        vector5.addElement(SYS_PROFILE_MODIFY);
        vector5.addElement(REBUILD_HSC);
        vector5.addElement(ISC_CREATE_PROFILE);
        vector5.addElement(ISC_UCODE_SURVEY);
        vector5.addElement(ISC_COLLECT_VPD);
        vector5.addElement(ISC_RESTART);
        vector5.addElement(SVAGENT_USER);
        vector5.addElement(CHANGE_LOCALE);
        vector5.addElement(RECEIVE_CORRECTIVE_SERVICE);
        vector5.addElement(SYS_PROFILE_VALIDATE);
        vector5.addElement(HMC_SHUTDOWN);
        vector5.addElement(CUOD_LICENSE);
        vector5.addElement(RESTORE_PROFILE_DATA);
        vector5.addElement(BACKUP_PROFILE_DATA);
        vector5.addElement(REMOVE_PROFILE_DATA);
        vector6.addElement(HSC_LOG_DISPLAYER);
        vector6.addElement(DISPLAY_SYSTEM_EVENTS);
        vector6.addElement(OS_HARDWARE_ERROR_DETECTION);
        vector6.addElement(UPDATE_HSC_DATE_TIME);
        vector6.addElement(BACKUP_HSC_DATA);
        vector6.addElement(SAVE_UPGRADE_DATA);
        vector6.addElement(INSTALL_SERVICE);
        vector6.addElement(FORMAT_MEDIA);
        vector6.addElement(VIEW_HSC_DATE_TIME);
        vector6.addElement(HSC_NETWORK_SETTINGS);
        vector6.addElement(HSC_NETWORK_TESTING);
        vector6.addElement(HSC_REMOTE_CMD);
        vector6.addElement(SERVICE_FOCAL_POINT_VIEW);
        vector6.addElement(SERVICE_FOCAL_POINT_UPDATE);
        vector6.addElement(SERVICE_FOCAL_POINT_SE_UPDATE);
        vector6.addElement(HARDWARE_SERVICE_FUNCTIONS_LED);
        vector6.addElement(CEC_OPEN_TERMINAL);
        vector6.addElement(CEC_CLOSE_TERMINAL);
        vector6.addElement(CEC_POWER_ON);
        vector6.addElement(CEC_FORCED_LOCK_RELEASE);
        vector6.addElement(CEC_POWER_OFF);
        vector6.addElement(CEC_MODIFY);
        vector6.addElement(FRAME_RESET);
        vector6.addElement(FRAME_REFRESH);
        vector6.addElement(FRAME_INITIALIZE);
        vector6.addElement(FRAME_MODIFY);
        vector6.addElement(FRAME_VIEW);
        vector6.addElement(FRAME_DEACTIVATE_IO);
        vector6.addElement(FRAME_DEACTIVATE_CSP);
        vector6.addElement(FRAME_DEACTIVATE_FSN);
        vector6.addElement(LPAR_ACTIVATE);
        vector6.addElement(LPAR_VIRTUAL_RESET);
        vector6.addElement(LPAR_READ_ERROR_VALUE);
        vector6.addElement(LPAR_MODIFY);
        vector6.addElement(DLPAR_TASK);
        vector6.addElement(PART_PROFILE_MODIFY);
        vector6.addElement(PART_PROFILE_COPY);
        vector6.addElement(PART_PROFILE_ACTIVATE);
        vector6.addElement(SYS_PROFILE_ACTIVATE);
        vector6.addElement(SYS_PROFILE_MODIFY);
        vector6.addElement(RESTORE_PROFILE_DATA);
        vector6.addElement(BACKUP_PROFILE_DATA);
        vector6.addElement(REMOVE_PROFILE_DATA);
        vector6.addElement(REBUILD_HSC);
        vector6.addElement(RECOVER_PARTITION_DATA);
        vector6.addElement(ISC_CREATE_PROFILE);
        vector6.addElement(ISC_UCODE_SURVEY);
        vector6.addElement(ISC_COLLECT_VPD);
        vector6.addElement(ISC_RESTART);
        vector6.addElement(SVAGENT_USER);
        vector6.addElement(CHANGE_LOCALE);
        vector6.addElement(RECEIVE_CORRECTIVE_SERVICE);
        vector6.addElement(SYS_PROFILE_VALIDATE);
        vector6.addElement(HSC_EVENT_TRACE);
        vector6.addElement(HMC_SHUTDOWN);
        _taskRoleMap = new Hashtable();
        _taskRoleMap.put(HSC_ADMIN_ROLE, vector);
        _taskRoleMap.put(HSC_OP_ROLE, vector2);
        _taskRoleMap.put(HSC_ADV_OP_ROLE, vector3);
        _taskRoleMap.put(HSC_SYS_PROG_ROLE, vector4);
        _taskRoleMap.put(HSC_SERV_REP_ROLE, vector5);
        _taskRoleMap.put(HSC_PE_MODE_ROLE, vector6);
        _taskRoleMap.put(HSC_VIEWER_ROLE, vector7);
        _taskRoleMap.put("root", vector4);
        Vector<String> vector8 = new Vector<String>();
        vector8.addElement(VIEW_HSC_DATE_TIME);
        vector8.addElement(CEC_VIEW);
        vector8.addElement(SYS_PROFILE_VIEW);
        vector8.addElement(LPAR_VIEW);
        vector8.addElement(PART_PROFILE_VIEW);
        vector8.addElement(VIEW_USER);
        _readAccess = new Hashtable();
        _readAccess.put(HSC_ADMIN_ROLE, vector8);
        _readAccess.put(HSC_OP_ROLE, vector8);
        _readAccess.put(HSC_ADV_OP_ROLE, vector8);
        _readAccess.put(HSC_SYS_PROG_ROLE, vector8);
        _readAccess.put(HSC_SERV_REP_ROLE, vector8);
        _readAccess.put(HSC_PE_MODE_ROLE, vector8);
        _readAccess.put(HSC_VIEWER_ROLE, vector8);
        Vector<String> vector9 = new Vector<String>();
        vector9.addElement(MODIFY_USER);
        Vector<String> vector10 = new Vector<String>();
        vector10.addElement(UPDATE_HSC_DATE_TIME);
        vector10.addElement(CEC_MODIFY);
        vector10.addElement(LPAR_MODIFY);
        vector10.addElement(DLPAR_TASK);
        vector10.addElement(PART_PROFILE_MODIFY);
        vector10.addElement(SYS_PROFILE_MODIFY);
        Vector<String> vector11 = new Vector<String>();
        vector11.addElement(UPDATE_HSC_DATE_TIME);
        vector11.addElement(CEC_MODIFY);
        vector11.addElement(FRAME_MODIFY);
        vector11.addElement(LPAR_MODIFY);
        vector11.addElement(DLPAR_TASK);
        vector11.addElement(PART_PROFILE_MODIFY);
        vector11.addElement(SYS_PROFILE_MODIFY);
        vector11.addElement(MODIFY_USER);
        Vector<String> vector12 = new Vector<String>();
        vector12.addElement(UPDATE_HSC_DATE_TIME);
        vector11.addElement(FRAME_MODIFY);
        vector12.addElement(SAVE_UPGRADE_DATA);
        _writeAccess = new Hashtable();
        _writeAccess.put(HSC_ADMIN_ROLE, vector9);
        _writeAccess.put(HSC_ADV_OP_ROLE, vector10);
        _writeAccess.put(HSC_SYS_PROG_ROLE, vector11);
        _writeAccess.put(HSC_SERV_REP_ROLE, vector12);
        _writeAccess.put(HSC_PE_MODE_ROLE, vector12);
        _writeAccess.put("root", vector11);
    }
}

